
<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', config('app.name', 'Ruche Connectée'))</title>

    {{-- Tailwind via CDN for simplicity (works fine alongside Vite if present) --}}
    <script src="https://cdn.tailwindcss.com"></script>

    {{-- If you use Vite, keep your vite tags here (optional) --}}
    @if(function_exists('vite'))
      @vite(['resources/css/app.css', 'resources/js/app.js'])
    @endif
  </head>
  <body class="bg-gray-100 min-h-screen">
    @auth
      @include('partials.sidebar')
      <div class="lg:pl-60">
        {{-- Top bar --}}
        <header class="h-16 bg-white border-b flex items-center justify-between px-4">
          <div class="font-semibold text-gray-700">
            @yield('title','Dashboard')
          </div>
          <div class="flex items-center gap-3">
            {{-- Auto refresh toggle (optional, dashboard listens to window event) --}}
            <button id="toggle-autorefresh" class="px-3 py-1 rounded-lg bg-gray-100 hover:bg-gray-200 text-sm">
              ⟳ Auto-refresh: <span id="autorefresh-state">OFF</span>
            </button>
            <span class="text-sm text-gray-500">Bonjour, {{ Auth::user()->name ?? 'Utilisateur' }}</span>
          </div>
        </header>

        <main class="p-4 md:p-6">
          @yield('content')
        </main>
      </div>
    @else
      {{-- For guests, just show content (e.g., login page) --}}
      <main class="p-4 md:p-6">
        @yield('content')
      </main>
    @endauth

    {{-- Global JS to broadcast auto-refresh toggle --}}
    <script>
    (function(){
      const btn = document.getElementById('toggle-autorefresh');
      const stateEl = document.getElementById('autorefresh-state');
      let enabled = false;
      let timer = null;

      function emit(){
        const ev = new CustomEvent('ruche:autorefresh', { detail: { enabled } });
        window.dispatchEvent(ev);
      }
      function start(){
        if (timer) return;
        timer = setInterval(()=>{
          window.dispatchEvent(new CustomEvent('ruche:tick'));
        }, 30000);
      }
      function stop(){
        if (timer) { clearInterval(timer); timer = null; }
      }

      btn?.addEventListener('click', ()=>{
        enabled = !enabled;
        stateEl && (stateEl.textContent = enabled ? 'ON' : 'OFF');
        if (enabled) start(); else stop();
        emit();
      });

      // Expose a way for pages to query state on load:
      window.addEventListener('ruche:need-state', ()=> emit());
    })();
    </script>

    {{-- Scripts pushed by pages --}}
    @stack('scripts')
  </body>
</html>
