@extends('layouts.app_sidebar')
@section('title','Index')
@section('content')
<div class="p-3 bg-white border rounded-3 card-honey mb-3"><h1 class="h5 mb-0">Ruches</h1></div>
<div class="bg-white border rounded-3">
  <table class="table table-hover align-middle mb-0">
    <thead class="table-light"><tr><th>Référence</th><th>Rucher</th><th>État</th><th>Installée</th><th></th></tr></thead>
    <tbody>
      @foreach($ruches as $r)
      <tr>
        <td class="fw-semibold">{{ $r->reference ?? ('Ruche #'.$r->id) }}</td>
        <td>{{ optional($r->rucher)->nom }}</td>
        <td>{{ $r->etat }}</td>
        <td>{{ $r->date_installation }}</td>
        <td><a class="btn btn-sm btn-outline-primary" href="{{ route('ruches.show', $r) }}">Ouvrir</a></td>
      </tr>
      @endforeach
    </tbody>
  </table>
</div>
<div class="mt-3">{{ $ruches->links() }}</div>
@endsection