@extends('layouts.app_sidebar')
@section('title','Show')
@section('content')
<div class="row g-3">
  <div class="col-12">
    <div class="p-3 bg-white border rounded-3 card-honey">
      <h1 class="h5 mb-0">{{ $ruche->reference ?? ('Ruche #'.$ruche->id) }}</h1>
      <div class="text-muted">Rucher : {{ optional($ruche->rucher)->nom }}</div>
      <div class="small">État : {{ $ruche->etat ?? '—' }} • Installée : {{ $ruche->date_installation ?? '—' }}</div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="p-3 bg-white border rounded-3 card-honey">
      <h2 class="h6">Capteurs</h2>
      <table class="table table-sm mb-0">
        <thead><tr><th>Type</th><th>Unité</th><th>Dernière mesure</th></tr></thead>
        <tbody>
          @forelse($ruche->capteurs as $c)
          <tr>
            <td class="fw-semibold">{{ $c->type }}</td>
            <td>{{ $c->unite ?? '—' }}</td>
            <td>
              @php $lastAt = $latest[$c->id] ?? null; @endphp
              {{ $lastAt ? \Carbon\Carbon::parse($lastAt)->diffForHumans() : '—' }}
            </td>
          </tr>
          @empty
          <tr><td colspan="3" class="text-muted">Aucun capteur.</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>
  <div class="col-md-6">
    <div class="p-3 bg-white border rounded-3 card-honey">
      <div class="d-flex align-items-center justify-content-between">
        <h2 class="h6 mb-0">Courbe</h2>
        <select id="typeSelect" class="form-select form-select-sm" style="max-width:220px">
          <option value="temperature">Température (°C)</option>
          <option value="humidity">Humidité (%)</option>
        </select>
      </div>
      <canvas id="chart" height="140"></canvas>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
const ctx = document.getElementById('chart');
let chart;
async function loadSeries(type) {
  const url = `{{ route('ruches.timeseries', $ruche) }}?type=${encodeURIComponent(type)}&limit=200`;
  const res = await fetch(url);
  const json = await res.json();
  const labels = json.data.map(p => new Date(p.t));
  const values = json.data.map(p => Number(p.val));
  if (chart) chart.destroy();
  chart = new Chart(ctx, {
    type: 'line',
    data: { labels, datasets: [{ label: `${json.reference} — ${type}`, data: values, tension: 0.25 }] },
    options: { responsive: true, scales: { x: { type: 'time', time: { unit: 'minute' } } } }
  });
}
const typeSelect  = document.getElementById('typeSelect');
typeSelect.addEventListener('change', () => loadSeries(typeSelect.value));
loadSeries(typeSelect.value);
</script>
@endpush