<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\SimpleLoginController;
use App\Http\Controllers\Web\DashboardController;
use App\Http\Controllers\Web\RucherController;
use App\Http\Controllers\Web\RucheController;

// Auth routes
Route::get('/login', [SimpleLoginController::class, 'show'])->name('login');
Route::post('/login', [SimpleLoginController::class, 'login'])->name('login.post');
Route::post('/logout', [SimpleLoginController::class, 'logout'])->name('logout');

// Protected UI
Route::middleware('auth')->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

    Route::get('/ruchers', [RucherController::class, 'index'])->name('ruchers.index');
    Route::get('/ruchers/{rucher}', [RucherController::class, 'show'])->name('ruchers.show');

    Route::get('/ruches', [RucheController::class, 'index'])->name('ruches.index');
    Route::get('/ruches/{ruche}', [RucheController::class, 'show'])->name('ruches.show');

    Route::get('/ruches/{ruche}/timeseries', [RucheController::class, 'timeseries'])->name('ruches.timeseries');
});
