
<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', config('app.name', 'Ruche Connectée')); ?></title>

    
    <script src="https://cdn.tailwindcss.com"></script>

    
    <?php if(function_exists('vite')): ?>
      <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php endif; ?>
  </head>
  <body class="bg-gray-100 min-h-screen">
    <?php if(auth()->guard()->check()): ?>
      <?php echo $__env->make('partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
      <div class="lg:pl-60">
        
        <header class="h-16 bg-white border-b flex items-center justify-between px-4">
          <div class="font-semibold text-gray-700">
            <?php echo $__env->yieldContent('title','Dashboard'); ?>
          </div>
          <div class="flex items-center gap-3">
            
            <button id="toggle-autorefresh" class="px-3 py-1 rounded-lg bg-gray-100 hover:bg-gray-200 text-sm">
              ⟳ Auto-refresh: <span id="autorefresh-state">OFF</span>
            </button>
            <span class="text-sm text-gray-500">Bonjour, <?php echo e(Auth::user()->name ?? 'Utilisateur'); ?></span>
          </div>
        </header>

        <main class="p-4 md:p-6">
          <?php echo $__env->yieldContent('content'); ?>
        </main>
      </div>
    <?php else: ?>
      
      <main class="p-4 md:p-6">
        <?php echo $__env->yieldContent('content'); ?>
      </main>
    <?php endif; ?>

    
    <script>
    (function(){
      const btn = document.getElementById('toggle-autorefresh');
      const stateEl = document.getElementById('autorefresh-state');
      let enabled = false;
      let timer = null;

      function emit(){
        const ev = new CustomEvent('ruche:autorefresh', { detail: { enabled } });
        window.dispatchEvent(ev);
      }
      function start(){
        if (timer) return;
        timer = setInterval(()=>{
          window.dispatchEvent(new CustomEvent('ruche:tick'));
        }, 30000);
      }
      function stop(){
        if (timer) { clearInterval(timer); timer = null; }
      }

      btn?.addEventListener('click', ()=>{
        enabled = !enabled;
        stateEl && (stateEl.textContent = enabled ? 'ON' : 'OFF');
        if (enabled) start(); else stop();
        emit();
      });

      // Expose a way for pages to query state on load:
      window.addEventListener('ruche:need-state', ()=> emit());
    })();
    </script>

    
    <?php echo $__env->yieldPushContent('scripts'); ?>
  </body>
</html>
<?php /**PATH C:\Users\wesne\ruche_connectee\projet_ruche\resources\views/layouts/app.blade.php ENDPATH**/ ?>