<?php

namespace App\Http\Controllers;

use View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\Role2;
use App\Permission2;
use App\Alerte;
use App\Ruche;
use App\TypeCapteur;
use App\Mesure;
use App\Capteur;

class DashboardController extends Controller
{

    private $menu='dashboard';
    
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function index()
    {
        $user = Auth::user();
        $dashboard_title = "BTSSN2-2021";
        $t_indicateurs=[];

        //Indicateurs
        $nb_users=User::count();
        $nb_roles=Role2::count();
        $nb_permissions=Permission2::count();

        $t_indicateurs["nb_users"]=$nb_users;
        $t_indicateurs["nb_roles"]=$nb_roles;
        $t_indicateurs["nb_permissions"]=$nb_permissions;

 
        $alertes=Alerte::orderby('id','desc')->get();

        //Pour chaque ruche
        $nbmax=122;
        $max=1;
        $t_dates=[];$t_data=[];
        $t_dates_temp=[];$t_data_temp=[];
        $ruches=[];
        $nb_ruches=2;

        $ruches=Ruche::whereIn('id',["1","2"])->get();
        $type_capteur_masse=TypeCapteur::find(5); //Masse
        foreach($ruches as $ruche) {
            //Capteur
            $capteur=Capteur::where('id_ruche','=',$ruche->id)->where('id_type_capteur','=',$type_capteur_masse->id)->first();  
            //Graphique
            $t_data[]=$this->getData($ruche->id,$type_capteur_masse->id,$nbmax,$t_dates); 
            $t_label_legend[]=$ruche->nom;
        }

        $type_capteur_temp=TypeCapteur::find(1); //Temperature
        foreach($ruches as $ruche) {
            //Capteur
            $capteur=Capteur::where('id_ruche','=',$ruche->id)->where('id_type_capteur','=',$type_capteur_temp->id)->first();
            //Graphique
            $t_data_temp[]=$this->getData($ruche->id,$type_capteur_temp->id,$nbmax,$t_dates_temp); 
        }

        //Dates
        $t_labels=$t_dates;
        $t_labels_temp=$t_dates_temp;
        //Couleur des courbes
        $t_colors=["#155193","#f6d3a7"];
        $t_colors_temp=["#ffb5c7","#17a337"];


        return view::make('dashboard',[
            "user"=>$user,'menu' => $this->menu,
            "alertes"=>$alertes,
            "dashboard_title"=>$dashboard_title,
            "t_indicateurs"=>$t_indicateurs,
            't_label_legend' => $t_label_legend,'nb_ruches'=>$nb_ruches,'max' =>$max,
            't_data' => $t_data,'t_labels' => $t_labels,'t_colors' => $t_colors,
            't_data_temp' => $t_data_temp,'t_labels_temp' => $t_labels_temp,'t_colors_temp' => $t_colors_temp,
        ]);
    }



     public function getData($id_ruche,$id_type_capteur,$nbmax,&$t_dates)
    {
        $t_data=[];
        $capteur=Capteur::where('id_ruche','=',$id_ruche)->where('id_type_capteur','=',$id_type_capteur)->first();
        if(!$capteur) return "";
        $mesures=Mesure::where('id_capteur','=',$capteur->id)->orderBy('date','ASC')->limit($nbmax)->get();

        foreach($mesures as $mesure) {
            $t_data[]=$mesure->valeur;
            if(!in_Array(substr($mesure->date,0,10),$t_dates)) $t_dates[]=substr($mesure->date,0,10);
        }

        return $t_data;
    }

}
