<?php namespace App\Http\Controllers;
 
use Auth\AuthController;
use App\User;
use App\Role2;
//use App\Permission;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use DB;
use App\Http\Requests\RoleRequest;
use App\Http\Requests\RoleChangeRequest;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;


class RolesController extends Controller {
 
    private $menu='roles';

    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 
    public function index()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $roles = Role2::all();
        $users= User::all();
        $users_roles=array();
        foreach($roles as $role) {
            $users_roles[$role->name]="";
            foreach($users as $user0) {
                if($user0->hasRole($role->name))
                    $users_roles[$role->name].=(($users_roles[$role->name]=="")?"":"<br/>").$user0->name;
            }
        }
        asort($users_roles);
        return View::make('acces.roles.index', [
            'roles' => $roles, 
            'menu' => $this->menu,
            'user'=>$user,
            'users_roles'=>$users_roles]
        );
    }


    public function create()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        return View::make('acces.roles.create',
            ['user' => $user,
            'menu' => $this->menu,
            ]);
    }

    public function store(RoleRequest $request)
    {
        $role = new Role;
        $role->name = strtoupper($request->name);
        $role->save();
 
        return Redirect::to('/roles');
    }
 

    public function edit($id)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $role = Role::find($id);
        $liste_premissions=Permission::orderby('name')->pluck("name","id")->toArray();

        $t_getPermissions=DB::table('role_has_permissions')
            ->where('role_id', '=', $id)
            ->pluck("permission_id")
            ->toArray();

        
        return View::make('acces.roles.edit', [ 
            'user' => $user,
            'role' => $role ,
            't_getPermissions' => $t_getPermissions, 
            'liste_premissions' => $liste_premissions,
            'menu' => $this->menu,
        ]);

    }
 
    public function update($id,RoleRequest $request)
    {
       
        $role = Role::find($id);
        $role->name = strtoupper($request->name);
        $role->save();

         //Attach Permissions

        //Détache les anciennes permissions
        DB::table('role_has_permissions')->where('role_id', '=', $role->id)->delete();
        if(isset($request->role_permissions)) {
            $t_role_permissions = $request->role_permissions;
            if(count($t_role_permissions)>0) {
                //Attache les nouveaux
                foreach($t_role_permissions as $permission_id) {
                    $permission = Permission::find($permission_id);
                    $role->givePermissionTo($permission );
                }
            }
        }

        return Redirect::to('/roles');
    }
 
     public function show($id)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $role = Role::find($id);
        $liste_premissions=Permission::orderby('name')->pluck("name","id")->toArray();

        $t_getPermissions=DB::table('role_has_permissions')
            ->where('role_id', '=', $id)
            ->pluck("permission_id")
            ->toArray();

        return View::make('acces.roles.show', [ 
            'user' => $user,
            'role' => $role ,
            't_getPermissions' => $t_getPermissions, 
            'liste_premissions' => $liste_premissions,
            'menu' => $this->menu,
        ]);

    }

    public function destroy($id)
    {
        DB::table('role_has_permissions')->where('role_id', '=', $id)->delete();
        DB::table('model_has_roles')->where('role_id', '=', $id)->delete();
        DB::table('roles')->where('id', '=', $id)->delete();
        //Role::destroy($id);
        return Redirect::to('/roles');
    }
 

    /**
     * Changement de profil
     *
     * @return Response
     */
    public function newprofil()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user) return Redirect::route( 'login' );
        $users_list=array();
        $res_list=array();
        $origine_user_id=User::where('id','=',Session::get('origine_id'))->first();
        if($origine_user_id) {
            if($origine_user_id->HasRole("ADMINISTRATEUR")) {
                $assigned_roles = DB::table('role_user')->where('user_id','=',$user->id)->get();
                $users_list=DB::table('users')
                    ->select(db::raw("CONCAT(nom,' ',prenom) as nom"), 'id')
                    ->orderby("nom")->pluck('nom', 'id')->toArray();
                foreach($users_list as $id=>$nom) {
                    $user_enc=User::find($id);
                    if(!$user_enc->hasrole('ADMINISTRATEUR') || ($origine_user_id->id==$id) ) {
                        $res_list[$id]=$nom;

                    }
                }
                return View::make('param.actions.index', ['users_list' => $res_list,'user' => $user]);
            }
        }
       return Redirect::to('/accueil');
    }

    /**
     * Display a listing of the role.
     *
     * @return Response
     */
    public function changeprofil(RoleChangeRequest $request)
    {
        //Attach Protocole
        $user_id = $request->user_id;
        if($user_id>0) {
            $user = User::find($user_id);  
            Session::put('id', $user->id);
            Session::put('nom', $user->full_name); 
            return Redirect::to('/home');
       }
       return ;
    }
 
      /**
     * Retour au profil d'origine
     *
     * @return Response
     */
    public function origine_profil()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        if(!$user) return Redirect::route( 'login' );
        $origine_user_id=User::where('id','=',Session::get('origine_id'))->first();
        if($origine_user_id->hasRole("ADMINISTRATEUR")) {
            $user = User::find($origine_user_id->id);
            Session::put('id', $user->id);
            Session::put('nom', $user->full_name);
            return Redirect::to('/home');
        }
       return Redirect::to('/home');
    }



}


