<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use DB;
use Hash;
use App\Http\Requests\UserRequest;
use Validator;

 
class UsersController extends Controller {
 
    private $menu='utilisateurs';

    public function index()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $users_list = User::all();
        $t_user=array();
        if(!$user->hasRole("ADMINISTRATEUR")) {
            foreach($users_list as $u) {
                if(!$u->hasRole("ADMINISTRATEUR")) $t_user[]=$u->id;
            }
            $users_list = User::wherein('id',$t_user)->get();
        } 
        return View::make('acces.users.index', 
            ['user' => $user,
            'menu' => $this->menu,
            'users_list'=>$users_list,
            'user'=>$user]);

    }
 

    public function create()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $liste_roles=Role2::pluck("name","id")->toArray();

        return View::make('acces.users.create',
            [
            'user' => $user, 
            'menu' => $this->menu,
            'liste_roles' => $liste_roles,
        ]);
    }
 

    public function store(UserRequest $request)
    {
        $user = new User;
        $user->name = strtoUpper($request->name);
        $user->email      = strtolower($request->email);
        $user->password   = Hash::make($request->password);

        $user->save();
 
        $t_users_role = $request->users_role;
        //Attache les rôles
        if($t_users_role) {
            $user->assignRole($t_users_role);
        }

        return Redirect::to('/users');
    }
 

    public function edit($id)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $user_sel = User::find($id);
        $liste_roles=Role2::pluck("name","id")->toArray();

        $t_getroles=DB::table('model_has_roles')
            ->where('model_id', '=', $user_sel->id)
            ->where('model_type','=','App\User')
            ->pluck("role_id")
            ->toArray();


        return View::make('acces.users.edit', [ 
            'user' => $user ,
            'menu' => $this->menu,
            'user_sel' => $user_sel ,
            't_getroles' => $t_getroles, 
            'liste_roles' => $liste_roles
        ]);
    }
 

    public function update($id,UserRequest $request)
    {
        $user_maj = User::find($id);

        //Garde ancien mot de passe par defaut
        $old_password=$user_maj->password;

        if($request->password=='') $user_maj->password=$old_password;
        else {
            $v = Validator::make($request->all(), [
                'password' => 'required|min:3',
            ]);

            if ($v->fails())
                return redirect()->back()->withErrors($v->errors());   

            $user_maj->password   = Hash::make($request->password); 
        }
        $user_maj->name = strtoUpper($request->name);
        $user_maj->email = strtolower($request->email);
        $user_maj->save();

        //Attach rôles
        $t_users_role = $request->users_role;

        //Détache les anciens rôles
        $roles=$user_maj->getRoleNames();
        foreach($roles as $role) $user_maj->removeRole($role);
        $user_maj->assignRole($t_users_role);
        return Redirect::to('/users');
    }
 

     public function show($id)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $user_sel = User::find($id);
        $liste_roles=Role2::pluck("name","id")->toArray();

        $t_getroles=DB::table('model_has_roles')
            ->where('model_id', '=', $user_sel->id)
            ->where('model_type','=','App\User')
            ->pluck("role_id")
            ->toArray();


        return View::make('acces.users.show', [ 
            'user' => $user ,
            'menu' => $this->menu,
            'user_sel' => $user_sel ,
            't_getroles' => $t_getroles, 
            'liste_roles' => $liste_roles
        ]);
    }


    public function destroy($id)
    {
        $user=User::find($id);
        if(count($user->getRoleNames())>0)  return Redirect::to('/users');
        if($user->hasAnyDirectPermission()) return Redirect::to('/users');
        User::destroy($id);
        
        return Redirect::to('/users');
    }
 


}