<div align="center">
  <img src="shots/logo.png" alt="kleur" height="120" />
</div>

<div align="center">
  <a href="https://npmjs.org/package/kleur">
    <img src="https://badgen.now.sh/npm/v/kleur" alt="version" />
  </a>
  <a href="https://github.com/lukeed/kleur/actions?query=workflow%3ACI">
    <img src="https://github.com/lukeed/kleur/workflows/CI/badge.svg?event=push" alt="CI" />
  </a>
  <a href="https://npmjs.org/package/kleur">
    <img src="https://badgen.now.sh/npm/dm/kleur" alt="downloads" />
  </a>
  <a href="https://packagephobia.now.sh/result?p=kleur">
    <img src="https://packagephobia.now.sh/badge?p=kleur" alt="install size" />
  </a>
</div>

<div align="center">The fastest Node.js library for formatting terminal text with ANSI colors~!</div>

## Features

* No dependencies
* Super [lightweight](#load-time) & [performant](#performance)
* Supports [nested](#nested-methods) & [chained](#chained-methods) colors
* No `String.prototype` modifications
* Conditional [color support](#conditional-support)
* [Fully treeshakable](#individual-colors)
* Familiar [API](#api)

---

As of `v3.0` the Chalk-style syntax (magical getter) is no longer used.<br>Please visit [History](#history) for migration paths supporting that syntax.

---


## Install

```
$ npm install --save kleur
```


## Usage

```js
import kleur from 'kleur';

// basic usage
kleur.red('red text');

// chained methods
kleur.blue().bold().underline('howdy partner');

// nested methods
kleur.bold(`${ white().bgRed('[ERROR]') } ${ kleur.red().italic('Something happened')}`);
```

### Chained Methods

```js
const { bold, green } = require('kleur');

console.log(bold().red('this is a bold red message'));
console.log(bold().italic('this is a bold italicized message'));
console.log(bold().yellow().bgRed().italic('this is a bold yellow italicized message'));
console.log(green().bold().underline('this is a bold green underlined message'));
```

<img src="shots/1.png" width="300" />

### Nested Methods

```js
const { yellow, red, cyan } = require('kleur');

console.log(yellow(`foo ${red().bold('red')} bar ${cyan('cyan')} baz`));
console.log(yellow('foo ' + red().bold('red') + ' bar ' + cyan('cyan') + ' baz'));
```

<img src="shots/2.png" width="300" />


### Conditional Support

Toggle color support as needed; `kleur` includes simple auto-detection which may not cover all cases.

```js
import kleur from 'kleur';

// manually disable
kleur.enabled = false;

// or use another library to detect support
kleur.enabled = require('color-support').level > 0;

console.log(kleur.red('I will only be colored red if the terminal supports colors'));
```


## API

Any `kleur` method returns a `String` when invoked with input; otherwise chaining is expected.

> It's up to the developer to pass the output to destinations like `console.log`, `process.stdout.write`, etc.

The methods below are grouped by type for legibility purposes only. They each can be [chained](#chained-methods) or [nested](#nested-methods) with one another.

***Colors:***
> black &mdash; red &mdash; green &mdash; yellow &mdash; blue &mdash; magenta &mdash; cyan &mdash; white &mdash; gray &mdash; grey

***Backgrounds:***
> bgBlack &mdash; bgRed &mdash; bgGreen &mdash; bgYellow &mdash; bgBlue &mdash; bgMagenta &mdash; bgCyan &mdash; bgWhite

***Modifiers:***
> reset &mdash; bold &mdash; dim &mdash; italic* &mdash; underline &mdash; inverse &mdash; hidden &mdash; strikethrough*

<sup>* <em>Not widely supported</em></sup>


## Individual Colors

When you only need a few colors, it doesn't make sense to import _all_ of `kleur` because, as small as it is, `kleur` is not treeshakeable, and so most of its code will be doing nothing. In order to fix this, you can import from the `kleur/colors` submodule which _fully_ supports tree-shaking.

The caveat with this approach is that color functions **are not** chainable~!<br>Each function receives and colorizes its input. You may combine colors, backgrounds, and modifiers by nesting function calls within other functions.

```js
// or: import * as kleur from 'kleur/colors';
import { red, underline, bgWhite } from 'kleur/colors';

red('red text');
//~> kleur.red('red text');

underline(red('red underlined text'));
//~> kleur.underline().red('red underlined text');

bgWhite(underline(red('red underlined text w/ white background')));
//~> kleur.bgWhite().underline().red('red underlined text w/ white background');
```

> **Note:** All the same [colors, backgrounds, and modifiers](#api) are available.

***Conditional Support***

The `kleur/colors` submodule also allows you to toggle color support, as needed.<br>
It includes the same initial assumptions as `kleur`, in an attempt to have colors enabled by default.

Unlike `kleur`, this setting exists as `kleur.$.enabled` instead of `kleur.enabled`:

```js
import * as kleur from 'kleur/colors';
// or: import { $, red } from 'kleur/colors';

// manually disabled
kleur.$.enabled = false;

// or use another library to detect support
kleur.$.enabled = require('color-support').level > 0;

console.log(red('I will only be colored red if the terminal supports colors'));
```


## Benchmarks

> Using Node v10.13.0

### Load time

```
chalk        :: 5.303ms
kleur        :: 0.488ms
kleur/colors :: 0.369ms
ansi-colors  :: 1.504ms
```

### Performance

```
# All Colors
  ansi-colors      x 183,435 ops/sec ±0.96% (94 runs sampled)
  chalk            x 677,371 ops/sec ±0.17% (94 runs sampled)
  kleur            x 718,990 ops/sec ±0.51% (91 runs sampled)
  kleur/colors     x 862,421 ops/sec ±0.19% (95 runs sampled)

# Stacked colors
  ansi-colors      x  23,647 ops/sec ±1.14% (90 runs sampled)
  chalk            x 332,056 ops/sec ±0.57% (94 runs sampled)
  kleur            x  75,924 ops/sec ±0.32% (98 runs sampled)
  kleur/colors     x 103,509 ops/sec ±0.30% (96 runs sampled)

# Nested colors
  ansi-colors      x  67,278 ops/sec ±0.72% (96 runs sampled)
  chalk            x 124,868 ops/sec ±0.34% (96 runs sampled)
  kleur            x 136,444 ops/sec ±0.16% (97 runs sampled)
  kleur/colors     x 143,956 ops/sec ±0.25% (95 runs sampled)
```


## History

This project originally forked [`ansi-colors`](https://github.com/doowb/ansi-colors).

Beginning with `kleur@3.0`, the Chalk-style syntax (magical getter) has been replaced with function calls per key:

```js
// Old:
c.red.bold.underline('old');

// New:
c.red().bold().underline('new');
```
> <sup><em>As I work more with Rust, the newer syntax feels so much better & more natural!</em></sup>

If you prefer the old syntax, you may migrate to `ansi-colors` or newer `chalk` releases.<br>Versions below `kleur@3.0` have been officially deprecated.


## License

MIT © [Luke Edwards](https://lukeed.com)
