@extends('layouts.dash')

@section('title') Permissions @stop
@section('title_card',"Permissions")
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <!-- <th width='1%' >Id</th> -->
                        <th width='10%' >Nom</th>
                        <th>Rôles autorisés</th>
                        <th width='10%'>Date/Heure de création</th>
                        <th width='75px'>
                            <a href="{!! url('permissions/create') !!}" class="btn btn-success">
                                <span class='ti-plus'></span></a> 
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($permissions as $permission)
                    <tr>
                        <!-- <td>{!! $permission->id !!}</td> -->
                        <td nowrap>
                            <a href="{!! url('permissions/'.$permission->id) !!}" >{!! $permission->name !!}</a>
                        </td>
                        <td nowrap>{!! $permission->getroles() !!}</td>
                        <td nowrap>{!! $permission->created_at->format('d M, Y h:i') !!}</td>
                        <td nowrap>
                        
                            <a href="./permissions/{!! $permission->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">
                                <span class='ti-pencil-alt'></span>
                            </a>

                            {!! Form::open(['url' => url('permissions/' . $permission->id), 'method' => 'DELETE']) !!}
                            {{ csrf_field() }}
                            <button class="btn btn-danger">
                                <span class='ti-trash'></span>
                            </button>
                            {!! Form::close() !!}
                        
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection