@extends('layouts.dash')

@section('title') Capteurs @stop
@section('title_card',"Capteurs")
@section('content')
    <div class="card">
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Nom du capteur</th>
                        <th>Ruche</th>
                        <th>Type de capteur</th>
                        <th width="1px" >Niveaux Alerte</th>
                        <th width="1px">Nb Mesures</th>
                        <th width="1px">Dernière Mesure</th>
                        <th width='115px'>
                            <a href="{!! url('capteurs/create') !!}" class="btn btn-success">
                                <span class='ti-plus'></span></a> 
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($capteurs as $capteur)
                    <tr>
                        <td>
                            <a href="{!! url('capteurs/'.$capteur->id) !!}" >{!! $capteur->nom !!}</a>
                        </td>
                        <td>{!! $capteur->NomRuche !!}</td>
                        <td nowrap>{!! $capteur->NomTypeCapteur !!}</td>
                        <td nowrap align="center">{!! '<span style="color:red">'.$capteur->alerte_bas . 
                            '</span> / <span style="color:green">'.
                                $capteur->alerte_haut.
                            '</span>' !!}</td>
                        <td nowrap align="center">{!! $capteur->NbMesures !!}</td>
                        <td nowrap align="center">{!! $capteur->LastMesure !!}</td>
                        <td nowrap>
                            <a href="./mesures_filtre/{!! $capteur->id_ruche.'/'.$capteur->id_type_capteur !!}" class="btn btn-warning pull-left" target="_blank" style="margin-right: 3px;">
                                <span class='fas fa-chart-line'></span>
                            </a>
                            <a href="./capteurs/{!! $capteur->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">
                                <span class='ti-pencil-alt'></span>
                            </a>

                            {!! Form::open(['url' => url('capteurs/' . $capteur->id), 'method' => 'DELETE']) !!}
                                {{ csrf_field() }}
                                <button class="btn btn-danger">
                                    <span class='ti-trash'></span>
                                </button>
                            {!! Form::close() !!}
                        
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection