@extends('layouts.dash')
@section('title') Tableau de bord @stop
@section('title_card',"Tableau de bord")
@section('content')

 <div class="row">

    <!-- GRAPH Masse-->
    <div class="col-md-4">
        <div class="card card-primary ">
            <div class="card-header">
                Masse
                <div class="card-tools">
                    <button type="button" class="btn bg-primary btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-primary btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="position-relative mb-4">
                    <canvas id="masse-chart" style="display: block; height: 570px; width: 528px;" class="chartjs-render-monitor"></canvas>
                </div>
            </div> 
        </div>      
    </div> 

    <!-- Graph Température -->
    <div class="col-md-4">
        <div class="card card-info">
            <div class="card-header">
                Températures 
                <div class="card-tools">
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="position-relative mb-4">
                    <canvas id="temp-chart" style="display: block; height: 570px; width: 528px;" class="chartjs-render-monitor"></canvas>
                </div>
            </div>
        </div> 
    </div>

    <!--  Alertes -->
    <div class="col-md-4">
        <div class="card card-danger">
            <div class="card-header">
                Alertes 
                <div class="card-tools">
                    <button type="button" class="btn bg-danger btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-danger btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                        <table id="_table" class="table table-condensed table-striped table-hover table-bordered">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Détail</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($alertes as $alerte )
                        <tr>
                            <td align="left">{!! $alerte->DateMesure !!}</td>
                            <td nowrap align="left">{!! "<b>".$alerte->RucheNom."</b>&nbsp;".$alerte->Detail !!}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div> 
    </div>
</div>

@endsection

@section('scripts')

<script>
  $(function () {
    $("#_table").DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": false,
      "responsive": true, 
      "autoWidth": false,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
        },
    })

  });
</script>


<script>
  $(function () {
    'use strict'
    var ticksStyle = {
      fontColor: 'black',
      fontStyle: 'bold'
    }
    var mode = 'index'
    var intersect = true

    
    @include("dashboard.script_graph_temp")
    @include("dashboard.script_graph_masse")

  })
</script>
@endsection
