@extends('layouts.dash')
@section('title') Tableau de bord @stop
@section('title_card',"Tableau de bord")
@section('content')

   <section class="content">
        <div class="container-fluid">
            <!-- Small boxes (Stat box) -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3>{!! $t_indicateurs["nb_users"]!!}</h3>
                        </div>
                        <div class="icon">
                            <i class="fa fa-group"></i>
                        </div>
                        <a href="{!! url('users') !!}" class="small-box-footer">Détail <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>


              <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3>{!! $t_indicateurs["nb_roles"]!!}</h3>
                            <p></p>
                        </div>
                        <div class="icon">
                            <i class="fa fa-bookmark"></i>
                        </div>
                        <a href="{!! url('roles') !!}" class="small-box-footer">Détail <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>

                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>{!! $t_indicateurs["nb_permissions"] !!}</h3>
                            <p></p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-pie-graph"></i>
                        </div>
                        <a href="{!! url('permissions') !!}" class="small-box-footer">Détail <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                     
            </div> 

   </div>

   <div class="card">
              <div class="card-header">
                <h3 class="card-title">Mesures</h3>

                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>
                  <button type="button" class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="row">
                  <div class="col-md-8">
                    <div class="chart-responsive">
                        <div class="chartjs-size-monitor">
                            <div class="chartjs-size-monitor-expand">
                              <div class></div>
                    </div>
                    <div class="chartjs-size-monitor-shrink">
                      <div class></div>
                    </div>
                </div>
                      <canvas id="pieChart" height="82" width="164" style="display: block; width: 164px; height: 82px;" class="chartjs-render-monitor"></canvas>
                    </div>
                    <!-- ./chart-responsive -->
                  </div>
                  <!-- /.col (Légende) -->
                  <div class="col-md-4">
                    <ul class="chart-legend clearfix">
                      <li><i class="far fa-circle text-danger"></i> Température </li>
                      <li><i class="far fa-circle text-success"></i> Humidité </li>
                      <li><i class="far fa-circle text-warning"></i> Pression </li>
                      <li><i class="far fa-circle text-info"></i> Luminosité </li>
                      <li><i class="far fa-circle text-primary"></i> Masse </li>
                      <li><i class="far fa-circle text-secondary"></i> ILS </li>
                    </ul>
                  </div>
                  <!-- /.col -->
                </div>
                <!-- /.row -->
              </div>
              <!-- /.card-body -->
              <div class="card-footer p-0">
                <ul class="nav nav-pills flex-column">
                  <li class="nav-item">
                    <a href="#" class="nav-link">
                      United States of America
                      <span class="float-right text-danger">
                        <i class="fas fa-arrow-down text-sm"></i>
                        12%</span>
                    </a>
                  </li>
                </ul>
              </div>
              <!-- /.footer -->
            </div>


            <!-- GRAPHIQUE EN ANNEAU -->
<!--            <div class="card card-danger">
              <div class="card-header">
                <h3 class="card-title">
                    <font style="vertical-align: inherit;">
                        <font style="vertical-align: inherit;">Graphique en anneau</font>
                    </font>
                </h3>

                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>
                  <button type="button" class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
              </div>
              <div class="card-body">
                <div class="chartjs-size-monitor">
                    <div class="chartjs-size-monitor-expand">
                    </div>
                    <div class="chartjs-size-monitor-shrink">
                    </div>
                </div>
                <canvas id="donutChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%; display: block; width: 629px;" width="629" height="250" class="chartjs-render-monitor"></canvas>
              </div>
             /.card-body -->
           <!--   </div>  -->
</section>

@endsection

@section('scripts')
  <script type="text/javascript">
    const config = {
  type: 'pie',
  data: data,
};
    const data = {
  labels: [
    'Red',
    'Blue',
    'Yellow'
  ],
  datasets: [{
    label: 'My First Dataset',
    data: [300, 50, 100],
    backgroundColor: [
      'rgb(255, 99, 132)',
      'rgb(54, 162, 235)',
      'rgb(255, 205, 86)'
    ],
    hoverOffset: 4
  }]
};
  </script>

@include("forms.scripts_datatable")
@endsection
