<?php

namespace App\Http\Controllers;

use View;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Role2;
use App\Models\Permission2;



class HomeController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function index()
    {
        $user = Auth::user();
        $dashboard_title = "BTSSN2-2021";
        $t_indicateurs=[];

        //Indicateurs
        $nb_users=User::count();
        $nb_roles=Role2::count();
        $nb_permissions=Permission2::count();


        $t_indicateurs["nb_users"]=$nb_users;
        $t_indicateurs["nb_roles"]=$nb_roles;
        $t_indicateurs["nb_permissions"]=$nb_permissions;



        $users=User::all();

        return view::make('home_Administrateur',[
            "user"=>$user,
            "users"=>$users,
            "dashboard_title"=>$dashboard_title,
            "t_indicateurs"=>$t_indicateurs,
        ]);
    }


}
