@extends('layouts.dash')
@section('title') Rôle @stop
@section('title_card')  @stop


@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-success">
        <div class="card-header">
            <h2>Rôle <span style='color:darkblue'>{!! $role->name !!}</span></h2>
        </div>
        <div class='card-body'>
            {{ html()->modelForm($role, 'PUT', url('/roles/' . $role->id))->open() }}
                @include("acces.roles.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
@stop

@section('scripts')
    <script>
        $(function() {
            $('.select2').select2();
        })
    </script>
@endsection
