@extends('layouts.dash')
@section('title') Permissions @stop
@section('title_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    <div class="card">
        <div class="card-header bg-warning">
            <h3>Permissions</h3>
        </div>
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <!-- <th width='1%' >Id</th> -->
                        <th width='10%' >Nom</th>
                        <th width='10%' >Libellé</th>
                        <th width='10%' >Groupe</th>
                        <th>Rôles autorisés</th>
                        <!-- <th width='10%'>Date/Heure de création</th> -->
                    </tr>
                </thead>
                <tbody>
                    @foreach ($permissions as $permission)
                    <tr>
                        <!-- <td>{!! $permission->id !!}</td> -->
                        <td nowrap>
                            <a href="{!! url('permissions/'.$permission->id) !!}" >{!! $permission->name !!}</a>
                        </td>
                        <td nowrap>{!! $permission->display_name !!}</td>
                        <td nowrap>{!! $permission->GroupeNom !!}</td>
                        <td nowrap>{!! $permission->getroles() !!}</td>
                        <!-- <td nowrap>{!! isset($permission->created_at)?$permission->created_at->format('d M, Y h:i'):"" !!}</td> -->
                    </tr>
                    @endforeach
                </tbody>
            </table>

            @if($user->hasRole("ADMINISTRATEUR")|| $user->can("PER_AJO"))
                <a href="{!! url('permissions/create') !!}" class="btn btn-sm btn-success">
                    <span class='fa fa-plus'></span>&nbsp;Ajouter une permission</a>
            @endif
        </div>
    </div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable")
@endsection
