<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\AlertEngine;

class ScanAlerts extends Command
{
    protected $signature = 'alerts:scan {--ref=} {--hours=24}';
    protected $description = 'Scanne les mesures et génère des alertes selon alert_settings (hystérésis inclus)';

    public function handle(): int
    {
        $ref   = $this->option('ref') ?: null;
        $hours = (int)$this->option('hours');

        $res = AlertEngine::scan($ref, $hours);

        $this->info("Scan terminé. Points scannés: {$res['scanned']}, alertes créées: {$res['created']}, auto-ack: {$res['auto_acked']}.");
        return self::SUCCESS;
    }
}
