<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Apiculteur;
use App\Models\Rucher;
use App\Models\Ruche;
use App\Models\Capteur;
use App\Models\Alerte;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'apiculteurs' => Apiculteur::count(),
            'ruchers'     => Rucher::count(),
            'ruches'      => Ruche::count(),
            'capteurs'    => Capteur::count(),
            'alertes'     => Alerte::count(),
        ];

        $ruches = Ruche::orderBy('reference')->take(50)->get();

        return view('dashboard.index', compact('stats', 'ruches'));
    }
}
