<?php

namespace App\Http\Middleware;

use Illuminate\Http\Middleware\TrustProxies as Middleware;
use Illuminate\Http\Request;

class TrustProxies extends Middleware
{
    /**
     * Les proxys de confiance. "*" = tous (pratique sur PaaS).
     * Pour restreindre : mets une liste d'IPs ou réseaux ici.
     *
     * @var array<int, string>|string|null
     */
    protected $proxies = '*';

    /**
     * Les en-têtes utilisés pour détecter le protocole/host/port d'origine.
     */
    protected $headers =
        Request::HEADER_X_FORWARDED_FOR |
        Request::HEADER_X_FORWARDED_HOST |
        Request::HEADER_X_FORWARDED_PORT |
        Request::HEADER_X_FORWARDED_PROTO |
        Request::HEADER_X_FORWARDED_AWS_ELB;
}
