<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('capteurs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ruche_id')->constrained('ruches')->cascadeOnDelete();
            $table->string('type', 100);
            $table->string('unite', 20)->nullable();
            $table->string('reference')->nullable();
            $table->timestamps();

            $table->unique(['ruche_id', 'type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('capteurs');
    }
};