<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('ruches', function (Blueprint $table) {
            if (!Schema::hasColumn('ruches', 'etat')) {
                $table->string('etat', 30)->default('active')->after('reference'); // ex: active, inactive, maintenance
            }
            if (!Schema::hasColumn('ruches', 'commentaire')) {
                $table->text('commentaire')->nullable()->after('etat');
            }
        });
    }

    public function down(): void
    {
        Schema::table('ruches', function (Blueprint $table) {
            if (Schema::hasColumn('ruches', 'commentaire')) {
                $table->dropColumn('commentaire');
            }
            if (Schema::hasColumn('ruches', 'etat')) {
                $table->dropColumn('etat');
            }
        });
    }
};