<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // 1) Nettoyage des doublons éventuels (garde la ligne avec l'id le plus récent)
        DB::statement('
            DELETE m FROM mesures m
            JOIN (
                SELECT capteur_id, measured_at, MAX(id) AS keep_id
                FROM mesures
                WHERE measured_at IS NOT NULL
                GROUP BY capteur_id, measured_at
                HAVING COUNT(*) > 1
            ) k ON k.capteur_id = m.capteur_id AND k.measured_at = m.measured_at
            WHERE m.id <> k.keep_id
        ');

        // 2) Ajout de l'index unique (empêche les doublons à l'avenir)
        Schema::table('mesures', function (Blueprint $table) {
            $table->unique(['capteur_id', 'measured_at'], 'mesures_capteur_measured_unique');
        });
    }

    public function down(): void
    {
        Schema::table('mesures', function (Blueprint $table) {
            $table->dropUnique('mesures_capteur_measured_unique');
        });
    }
};
