<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        if (Schema::hasTable('users')) {
            Schema::table('users', function (Blueprint $table) {
                if (!Schema::hasColumn('users', 'role')) {
                    $table->string('role')->default('apiculteur')->after('password');
                }
                if (!Schema::hasColumn('users', 'apiculteur_id')) {
                    $table->foreignId('apiculteur_id')
                          ->nullable()
                          ->after('role')
                          ->constrained('apiculteurs')
                          ->nullOnDelete();
                }
            });
        }
    }

    public function down(): void {
        if (Schema::hasTable('users')) {
            Schema::table('users', function (Blueprint $table) {
                if (Schema::hasColumn('users', 'apiculteur_id')) {
                    $table->dropConstrainedForeignId('apiculteur_id');
                }
                if (Schema::hasColumn('users', 'role')) {
                    $table->dropColumn('role');
                }
            });
        }
    }
};
