<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AlertBootstrapSeeder extends Seeder
{
    public function run(): void
    {
        // Types cibles et seuils par défaut
        $defaults = [
            'temperature' => ['min' => 15,  'max' => 35,  'hyst' => 1.0],
            'humidity'    => ['min' => 30,  'max' => 85,  'hyst' => 2.0],
            'weight'      => ['min' => null,'max' => null,'hyst' => 0.5],
            'battery'     => ['min' => 3.50,'max' => null,'hyst' => 0.05],
        ];

        // Capteurs existants ruche×type
        $rows = DB::table('capteurs as c')
            ->join('ruches as r','r.id','=','c.ruche_id')
            ->select('r.id as ruche_id', 'r.reference as ruche_ref', 'c.type')
            ->groupBy('r.id','r.reference','c.type')
            ->get();

        $now = now();
        $created = 0;

        foreach ($rows as $row) {
            $type = trim((string)$row->type);
            if ($type === '') continue;

            $exists = DB::table('alert_settings')
                ->where('ruche_id', $row->ruche_id)
                ->where('type', $type)
                ->exists();

            if ($exists) continue;

            $d = $defaults[$type] ?? ['min'=>null,'max'=>null,'hyst'=>0.5];

            DB::table('alert_settings')->insert([
                'ruche_id'      => $row->ruche_id,
                'type'          => $type,
                'threshold_min' => $d['min'],
                'threshold_max' => $d['max'],
                'hysteresis'    => $d['hyst'],
                'enabled'       => 1,
                'created_at'    => $now,
                'updated_at'    => $now,
            ]);
            $created++;
        }

        $this->command?->info("AlertBootstrapSeeder: $created réglages créés.");
    }
}
