<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AlertSetting;
use App\Models\Ruche;

class AlertSeeder extends Seeder
{
    public function run(): void
    {
        $ruche = Ruche::first();
        if(!$ruche) return;

        AlertSetting::create([
            'ruche_id' => $ruche->id,
            'type' => 'temperature',
            'threshold_min' => 15,
            'threshold_max' => 35,
            'hysteresis' => 1,
            'enabled' => true,
        ]);
    }
}
