<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Seeder de démo du projet (garde-le si tu l'utilises)
        $this->call([
            DemoDataSeeder::class,
        ]);

        // ---- Admin par défaut (override via .env si tu veux) ----
        $email = env('ADMIN_EMAIL', 'admin@ruche.local');
        $pass  = env('ADMIN_PASSWORD', 'admin123');

        User::updateOrCreate(
            ['email' => $email],
            [
                'name'     => 'Administrateur',
                'password' => Hash::make($pass),
                'role'     => 'admin',
            ]
        );
    }
}
