<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class MesureSeeder extends Seeder
{
    public function run(): void
    {
        $now = Carbon::now(); // ou now()
        $points = [];

        // capteur_id = 1 (temp), capteur_id = 2 (hum)
        for ($i = 0; $i < 48; $i++) {
            // 24h d’historique, un point toutes les 30 minutes
            $t = $now->copy()->subMinutes(30 * (48 - $i));

            $points[] = [
                'capteur_id'  => 1,
                'valeur'      => 24.5 + mt_rand(-15, 15) / 10, // 23.0–26.0
                'measured_at' => $t,
                'created_at'  => $t,
                'updated_at'  => $t,
            ];

            $points[] = [
                'capteur_id'  => 2,
                'valeur'      => 55 + mt_rand(-30, 30) / 10,   // 52.0–58.0
                'measured_at' => $t,
                'created_at'  => $t,
                'updated_at'  => $t,
            ];
        }

        DB::table('mesures')->insert($points);
    }
}
