<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Apiculteur;
use App\Models\Rucher;
use App\Models\Ruche;

class RucheDemoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // 1) User de test
        $user = User::firstOrCreate(
            ['email' => 'test@example.com'],
            ['name' => 'Test User', 'password' => Hash::make('password')]
        );

        // 2) Apiculteur lié au user
        $api = Apiculteur::firstOrCreate(
            ['user_id' => $user->id],
            ['nom' => 'Dupont', 'prenom' => 'Alice', 'email' => 'api@example.com', 'telephone' => '0000']
        );

        // 3) Rucher
        $rucher = Rucher::firstOrCreate(
            ['apiculteur_id' => $api->id, 'nom' => 'Rucher Nord'],
            ['localisation' => 'GPS: -22.27, 166.44', 'description' => 'Jeu de test']
        );

        // 4) Ruche (reference = device_id TTN attendu)
        Ruche::firstOrCreate(
            ['rucher_id' => $rucher->id, 'reference' => 'ruche-001'],
            ['etat' => 'active', 'commentaire' => 'Demo TTN']
        );
    }
}
