@extends('layouts.app_sidebar')
@section('title','App_sidebar')
<!doctype html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}">
  <head>
    <meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name','Laravel') }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    @stack('styles')
  </head>
  <body>
    @auth
      <div class="d-flex">
        @include('layouts.partials.sidebar')
        <div class="flex-grow-1">
          <nav class="navbar bg-white border-bottom sticky-top">
            <div class="container-fluid">
              <span class="navbar-brand mb-0 h1">@yield('title','Tableau de bord')</span>
            </div>
          </nav>
          <main class="container py-4">@yield('content')</main>
        </div>
      </div>
    @endauth

    @guest
      {{-- fallback invité : nav existante --}}
      @include('layouts.navigation')
      <main class="container py-4">@yield('content')</main>
    @endguest

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    @stack('scripts')
  </body>
</html>