<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AlertController;   // ← AJOUT
use App\Http\Controllers\ExportController;  // ← AJOUT

/*
|--------------------------------------------------------------------------
| Web Routes (protégées par auth)
|--------------------------------------------------------------------------
| - Dashboard, Alertes, Export et Profil accessibles uniquement si connecté.
| - Les routes d'auth (login/register/forgot) sont chargées via routes/auth.php.
*/

Route::middleware('auth')->group(function () {
    // Dashboard
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/dashboard', [DashboardController::class, 'index']);

    // --- ALERTES (CRUD simple) ---
    Route::get('/alerts', [AlertController::class, 'index'])->name('alerts.index');
    Route::post('/alerts/bootstrap', [AlertController::class, 'bootstrap'])->name('alerts.bootstrap');
    Route::post('/alerts/{id}/update', [AlertController::class, 'update'])->name('alerts.update');
    Route::delete('/alerts/{id}', [AlertController::class, 'destroy'])->name('alerts.destroy');

    // --- EXPORT CSV ---
    Route::get('/export/{ref}.csv', [ExportController::class, 'exportCsv'])->name('export.csv');

    // Page Profil (nommée 'profile.edit' pour compatibilité avec la nav)
    Route::get('/profile', function () {
        return view('profile');
    })->name('profile.edit');
});

// Charge les routes d'authentification (Breeze/Jetstream/Fortify…)
if (file_exists(__DIR__ . '/auth.php')) {
    require __DIR__ . '/auth.php';
}
