
<aside class="fixed inset-y-0 left-0 w-60 bg-white border-r border-gray-200 z-30">
  <div class="h-16 flex items-center px-4 border-b">
    <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-2 font-bold text-gray-800">
      🐝 <span>Ruche Connectée</span>
    </a>
  </div>
  <nav class="p-3 space-y-1">
    <a href="<?php echo e(route('dashboard')); ?>"
       class="flex items-center gap-2 px-3 py-2 rounded-lg <?php echo e(request()->routeIs('dashboard') || request()->routeIs('dashboard.index') ? 'bg-indigo-50 text-indigo-700' : 'text-gray-700 hover:bg-gray-50'); ?>">
      <span class="w-5 text-center">📊</span> <span>Dashboard</span>
    </a>
    <a href="<?php echo e(route('alerts.index')); ?>"
       class="flex items-center gap-2 px-3 py-2 rounded-lg <?php echo e(request()->routeIs('alerts.index') || request()->is('alerts*') ? 'bg-indigo-50 text-indigo-700' : 'text-gray-700 hover:bg-gray-50'); ?>">
      <span class="w-5 text-center">🚨</span> <span>Alertes</span>
    </a>
    <button id="open-export" type="button"
       class="w-full text-left flex items-center gap-2 px-3 py-2 rounded-lg text-gray-700 hover:bg-gray-50">
      <span class="w-5 text-center">⬇️</span> <span>Export CSV</span>
    </button>
    <a href="<?php echo e(route('profile.edit')); ?>"
       class="flex items-center gap-2 px-3 py-2 rounded-lg <?php echo e(request()->routeIs('profile.edit') ? 'bg-indigo-50 text-indigo-700' : 'text-gray-700 hover:bg-gray-50'); ?>">
      <span class="w-5 text-center">👤</span> <span>Profil</span>
    </a>
  </nav>
  <div class="absolute bottom-0 left-0 right-0 p-3 border-t">
    <form method="POST" action="<?php echo e(route('logout')); ?>">
      <?php echo csrf_field(); ?>
      <button class="w-full px-3 py-2 rounded-lg bg-gray-100 hover:bg-gray-200 text-gray-800">
        Se déconnecter
      </button>
    </form>
  </div>
</aside>


<div id="export-modal" class="hidden fixed inset-0 bg-black/30 z-40">
  <div class="absolute inset-0 flex items-center justify-center p-4">
    <div class="w-full max-w-md bg-white rounded-2xl shadow p-5 space-y-3">
      <div class="flex items-center justify-between">
        <h3 class="text-lg font-semibold">Export CSV</h3>
        <button id="close-export" class="text-gray-500 hover:text-gray-700">✖</button>
      </div>
      <div class="space-y-2">
        <label class="block text-sm">Ruche</label>
        <input id="export-ref" type="text" class="w-full border rounded-lg px-3 py-2" value="<?php echo e($ref ?? request('ref','ruche-001')); ?>">
        <label class="block text-sm mt-2">De</label>
        <input id="export-from" type="datetime-local" class="w-full border rounded-lg px-3 py-2">
        <label class="block text-sm mt-2">À</label>
        <input id="export-to" type="datetime-local" class="w-full border rounded-lg px-3 py-2">
      </div>
      <div class="flex justify-end gap-2 pt-2">
        <button id="do-export" class="px-4 py-2 rounded-lg bg-emerald-600 text-white hover:bg-emerald-700">Exporter</button>
      </div>
    </div>
  </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
(function(){
  const pad2 = n => String(n).padStart(2,'0');
  const toLocalISO = (d) => {
    const y=d.getFullYear(), m=pad2(d.getMonth()+1), dd=pad2(d.getDate());
    const hh=pad2(d.getHours()), mm=pad2(d.getMinutes());
    return `${y}-${m}-${dd}T${hh}:${mm}`;
  };

  const modal = document.getElementById('export-modal');
  const openBtn = document.getElementById('open-export');
  const closeBtn = document.getElementById('close-export');
  const doExport = document.getElementById('do-export');
  const fromI = document.getElementById('export-from');
  const toI = document.getElementById('export-to');
  const refI = document.getElementById('export-ref');

  if (fromI && toI) {
    const now = new Date();
    const fromDefault = new Date(now.getTime() - 24*3600*1000);
    fromI.value = toLocalISO(fromDefault);
    toI.value   = toLocalISO(now);
  }

  openBtn?.addEventListener('click', ()=> modal.classList.remove('hidden'));
  closeBtn?.addEventListener('click', ()=> modal.classList.add('hidden'));
  modal?.addEventListener('click', (e)=> { if (e.target === modal) modal.classList.add('hidden'); });

  doExport?.addEventListener('click', ()=>{
    const ref  = refI.value || 'ruche-001';
    const from = fromI.value;
    const to   = toI.value;
    const params = new URLSearchParams();
    if (from) params.set('from', new Date(from).toISOString());
    if (to)   params.set('to',   new Date(to).toISOString());
    const url = `/export/${encodeURIComponent(ref)}.csv?` + params.toString();
    window.location.href = url;
  });
})();
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\Users\wesne\ruche_connectee\projet_ruche\resources\views/partials/sidebar.blade.php ENDPATH**/ ?>